# keio-basic-experiment-template

このリポジトリは慶應義塾大学理工学部の理工学基礎実験のレポートをLaTeXで書くためのテンプレートです。

## 機能

以下のような機能があります。

- LaTeXを使用した組版処理
- scripts/graph.pyにより測定データからグラフを自動生成
- 指定の表紙を自動で結合
- BibTeXを用いた文献管理

## 動作環境

- LaTeX関係
  - uplatex
  - pdfdvimx
  - pbibtex
  - 以下のパッケージ
    - jsarticle
    - graphicx
    - siunitx
    - amssymb
    - amsmath
    - url
- LaTeX以外
  - MS Word - 指定の表紙がdocx形式であるため、表紙を作成するのに必要
  - qpdf - 表紙のPDFを結合するために必要
  - make
  - git

## セットアップ

### 1. LaTeXのインストール

TeX Liveのfull-schemeをインストールすれば十分です。

### 2. MS Word

適当にインストールします。

### 3. qpdf、make、git

[scoop](https://scoop.sh/)を使用する場合、以下のコマンドでインストールできます。

```sh
scoop install git
scoop install qpdf make
```

### 4. git clone

このリポジトリを適当な場所にgit cloneします。

### 5. ltx

`hoge.ltx`を適当な名前に変更します。空白を含まないASCII文字のみで構成されたファイル名がよいでしょう。`Makefile`の`SOURCE = hoge`と書かれた行も合わせて変更します。

## 使用方法

### 表紙なしのPDFを作る

```sh
make
```

または

```sh
make all
```

### コンパイルの中間ファイルを削除する

```sh
make clean
```

### dviファイルとPDFファイル、graph.pyで作成した図も含む中間ファイルを削除する

```sh
make clean-all
```

### 表紙付きのPDFファイルを作る

実験準備室が配布している表紙テンプレートをWordで編集し、ltxファイルと同じディレクトリにcover.pdfという名前で保存します。そして、以下のコマンドを実行します。

```sh
make add-cover
```

### scripts/graph.pyでグラフを描く

1. 測定データをscriptsフォルダ内にcsv形式で用意する
2. すでに書かれている`render_exp3_freq`関数がサンプルなので、それを参考に必要な関数を追加する。基本的に1枚のグラフに1つの関数が対応します。
3. `args.figure == ...`の辺りにも追記する
4. Makefileの`GEN_GRAPHS`の辺りを適当に編集する

わからない人は諦めてExcelを使うかがんばって手描きしてください。

## FAQ

### makeしたときに意味わからんエラーが出る

絶対にコードが間違っていないという自信がある場合は`make clean-all && make`を実行すると上手くいくかもしれません。

### BibTeXがエラーを吐く

ltxファイル内の`\nocite*{}`を削除し、`make clean-all && make`を実行してください。それでも直らない場合は知りません。

