import csv
import matplotlib.pyplot as plt
import numpy as np
import argparse
import os
import sys

def render_exp3_freq() -> None:
    f_in = np.array([])
    v_out = np.array([])
    f_out = np.array([])
    with open('exp3_freq.csv', mode='r', newline='') as csvfile:
        reader = csv.reader(csvfile, delimiter=',')
        for row in reader:
            print("row:", row)
            f_in = np.append(f_in, float(row[0]))
            v_out = np.append(v_out, float(row[1]))
            f_out = np.append(f_out, float(row[2]))

    plt.scatter(f_in, v_out, label="微分回路の入力周波数と出力電圧の関係")
    plt.xlabel("入力周波数 / kHz")
    plt.ylabel("出力電圧 / V")
    plt.savefig("../exp3_freq.png")
    if(args.preview):
        plt.show()

if __name__ == '__main__':
    os.chdir(sys.path[0])

    plt.rcParams['font.family'] = "MS Gothic"
    plt.rcParams['xtick.direction'] = 'in'
    plt.rcParams['ytick.direction'] = 'in'

    parser = argparse.ArgumentParser()
    parser.add_argument("figure")
    parser.add_argument("-p", "--preview", action="store_true")
    args = parser.parse_args()

    if args.figure == "exp3_freq":
        render_exp3_freq()
    else:
        print(f"unknown figure {args.figure}")
